<?php

return [
    "favicon" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['favicon'],
            "mode" => "upload",
        ]
    ],
    'logo' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'header_phone' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => "(+90) 212 909 56 76"
        ],
    ],
    'show_change_currency' => 'anomaly.field_type.boolean',
    'slider_banner' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'slider_banner_content' => [
        'type' => 'anomaly.field_type.wysiwyg',
        "config" => [
            "default_value" => '<h5>Sale Offer <span>-20% Off</span> This Week</h5>
                                <h2>Chamcham Galaxy S9 | S9+</h2>
                                <h3>Starting at <span>$589.00</span></h3>',
        ]
    ],
    'home_advs_category_1' => [
        "type" => "anomaly.field_type.select",
        'config' => [
            'options' => function (\Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface $categoryRepository) {
                return $categoryRepository->getMainCategories()->pluck('name', 'id')->all();
            },
            "default_value" => 7
        ],
    ],
    'home_advs_category_2' => [
        "type" => "anomaly.field_type.select",
        'config' => [
            'options' => function (\Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface $categoryRepository) {
                return $categoryRepository->getMainCategories()->pluck('name', 'id')->all();
            },
            "default_value" => 39
        ],
    ],
    'footer_address' => [
        'type' => 'anomaly.field_type.textarea',
        'config' => [
            'default_value' => "Princess Road, London, Greater London BAS 23JK, UK"
        ],
    ],
    'footer_phone' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => "(+90) 212 909 56 76"
        ],
    ],
    'footer_email' => [
        'type' => 'anomaly.field_type.text',
    ],
    'instagram' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => "#"
        ],
    ],
    'youtube' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => "#"
        ],
    ],
    'facebook' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => "#"
        ],
    ],
    'twitter' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => "#"
        ],
    ],
    'bestsellers_category' => [
        'type' => 'anomaly.field_type.checkboxes',
        'config' => [
            'options' => static function () {
                return \Visiosoft\CatsModule\Category\CategoryModel::query()
                    ->whereNull('parent_category_id')
                    ->get()->pluck('name', 'id')
                    ->all();
            },
            'max' => '3',
            'mode' => 'tags',
        ]
    ],
];