<?php namespace Visiosoft\LabelsModule\Label\Command;

use Visiosoft\LabelsModule\Image\Contract\ImageRepositoryInterface;
use Visiosoft\LabelsModule\Label\Contract\LabelInterface;

class CheckUsage
{
    protected $label;

    public function __construct(LabelInterface $label)
    {
        $this->label = $label;
    }

    public function handle(ImageRepositoryInterface $imageRepository)
    {
        $images = $imageRepository->findAllBy('rel_label_id', $this->label->id);

        if (count($images)) {
            $productsIDs = implode(', ', $images->pluck('product_id')->all());
            return trans(
                'visiosoft.module.labels::field.label_is_used_in_the_following_ads',
                ['labelName' => $this->label->label, 'adsIDs' => $productsIDs]
            );
        }

        return false;
    }
}
