<?php namespace Visiosoft\LabelsModule\Http\Controller;

use Anomaly\FilesModule\File\FileUploader;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\LabelsModule\Image\Contract\ImageRepositoryInterface;

class ImagesController extends PublicController
{
    private $advRepository;
    private $imageRepository;

    public function __construct(AdvRepositoryInterface $advRepository, ImageRepositoryInterface $imageRepository)
    {
        parent::__construct();
        $this->advRepository = $advRepository;
        $this->imageRepository = $imageRepository;
    }

    public function store($productID)
    {
        $ad = $this->advRepository->getModel()->findOrFail($productID);

        $this->checkAd($ad);

        request()->validate([
            'label' => 'required|exists:labels_labels,id',
        ]);

        $productImage = null;
        if (request('product_image')) { // Updating or moving
            $productImage = $this->imageRepository->find(request()->product_image);
        }

        // When creating
        if (!$productImage) {
            request()->validate([
                'image' => 'required',
            ]);
        }

        try {
            $data = ['note' => request('note')];

            if ($this->request->file('image')) { // New image
                $image = $this->upload();
                $data['image'] = $image;
            } elseif ($productImage) { // Use old image
                $image = $productImage->image;
                $data['image'] = $image;
            }

            $data = array_merge([
                'rel_label_id' => request('label'),
                'product_id' => $productID
            ], $data);

            if ($productImage) {
                $productImage->update($data);
            } else {
                $productImage = $this->imageRepository->create($data);
            }

            return [
                'success' => true,
                'data' => [
                    'url' => $productImage->image->make()->url(),
                    'product' => $productID,
                    'label' => request('label'),
                    'productImage' => $productImage,
                ]
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }

    public function update($imageID)
    {
        if (!$productImage = $this->imageRepository->find($imageID)) {
            abort(404);
        }

        $ad = $this->advRepository->getModel()->findOrFail($productImage->product_id);

        $this->checkAd($ad);

        request()->validate([
            'label' => 'exists:labels_labels,id',
        ]);

        try {
            $data = ['note' => request('note')];

            if ($this->request->file('image')) { // New image
                $image = $this->upload();
                $data['image'] = $image;
            } else { // Use old image
                $image = $productImage->image;
                $data['image'] = $image;
            }

            $data = array_merge([
                'rel_label_id' => request('label') ?? $productImage->rel_label_id,
                'product_id' => $productImage->product_id
            ], $data);

            $productImage->update($data);

            return [
                'success' => true,
                'data' => [
                    'url' => $productImage->image->make()->url(),
                    'product' => $productImage->product_id,
                    'label' => request('label'),
                    'productImage' => $productImage,
                ]
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }

    protected function upload()
    {
        $uploader = app(FileUploader::class);
        $folders = app(FolderRepositoryInterface::class);
        $folder = $folders->findBySlug('images');

        if ($file = $uploader->upload(
            $this->request->file('image'),
            $folder
        )
        ) {
            return $file;
        }

        throw new \Exception(trans('visiosoft.module.labels::field.an_error_occurred'));
    }

    public function delete($imageID)
    {
        try {
            if ($image = $this->imageRepository->find($imageID)) {
                $image->delete();
            }

            return [
                'success' => true,
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage(),
            ];
        }
    }

    protected function checkAd($ad)
    {
        if (!$ad->canEdit()) {
            abort(404);
        }
    }
}
