function hierarchicalSort(categories, sorted, parentID) {
    var i = categories.length;

    while (--i >= 0) {
        var category = categories.shift();
        if (category.parent_category_id == parentID) {
            sorted.push(category);
        } else {
            categories.push(category);
        }
    }

    for (var j = 0; typeof sorted[j] !== 'undefined'; j++) {
        sorted[j].children = [];

        hierarchicalSort(categories, sorted[j].children, sorted[j].id);
    }
}

const categoriesContainer = $('.categories');

const labelID = window.location.pathname.split("/").pop();
let selectedCats;
if (Number(labelID)) {
    crudAjax('', `/api/admin/labels/get-selected-categories/${labelID}`, 'GET', () => {}, true)
        .then(function (res) {
            if (res.success) {
                selectedCats = res.data;

                getAllCats();
            } else {
                alert(res.msg);
            }
        });
} else {
    getAllCats();
}

function getAllCats() {
    crudAjax('', '/admin/api/cats/all', 'GET', () => {}, true)
        .then(function (res) {
            if (res.success) {
                categoriesContainer.children().hide();

                sortCats(res.data);
            } else {
                alert(res.msg);
            }
        });
}

const categoriesTrans = $('.categories-field label').text();
function sortCats(cats) {
    let sorted = [];
    hierarchicalSort(cats, sorted, null);

    categoriesContainer.append(`
        <label class="control-label" for="categories">${categoriesTrans}</label>

        <ul class="accounts">
           ${addCatsHTML(sorted)}
        </ul>
    `);
}

function addCatsHTML(cats) {
    let categoryList = '';
    for (let i = 0; i < cats.length; i++) {
        const cat = cats[i];

        let childrenHTML;
        if (cat.children.length) {
            childrenHTML = addCatsHTML(cat.children);
        }

        categoryList += `
            <li>
                <label>
                    <input ${selectedCats && selectedCats.indexOf(cat.id) != -1 ? 'checked' : ''} type="checkbox"
                        name="selected_cats" value="${cat.id}" />
                    ${cat.name}
                </label>
                ${!childrenHTML ? '' : `
                    <ul class="subaccounts">
                      ${childrenHTML}
                    </ul>
                `}
            </li>
        `;
    }

    return categoryList;
}

function checkParents(li, state) {
    const siblings = li.siblings();
    let parent = li.parent().closest('li');

    const inputs = siblings.children('label').find('input');
    let isChecked = true;
    for (let i = 0; i < inputs.length; i++) {
        const input = $(inputs[i]);

        if (!input.prop('checked')) {
            isChecked = false;
            break;
        }
    }

    state = state && isChecked;
    parent.children('label').find('input').prop('checked', state);
    if (parent.parents('li').length) {
        checkParents(parent, state);
    }
}

$(categoriesContainer).on('change', 'input', function () {
    const cb = $(this);
    const li = cb.closest('li');
    const state = cb.prop('checked');

    // check all children
    li.find('input').prop('checked', state);

    // check all parents, as applicable
    if (li.parents('li').length) {
        checkParents(li, state);
    }
});

$('form').submit(function () {
    let value = [];
    $('[name=selected_cats]:checked').each(function (index, input) {
        value.push($(input).val());
    })

    $('[name=categories]').val(value.length ? value.join() : '');
});
