// File Upload
function ekUpload() {
    function Init() {
        $(document).on('change', '#fileUpload', fileSelectHandler);

        // Is XHR2 available?
        var xhr = new XMLHttpRequest();
        if (xhr.upload) {
            // File Drop
            $(document).on('dragover', '#fileDrag', fileDragHover);
            $(document).on('dragleave', '#fileDrag', fileDragHover);
            $(document).on('drop', '#fileDrag', fileSelectHandler);
        }
    }

    function fileDragHover(e) {
        var fileDrag = document.getElementById('fileDrag');

        e.stopPropagation();
        e.preventDefault();

        fileDrag.className = (e.type === 'dragover' ? 'mb-2 hover' : 'mb-2 modal-body file-upload');
    }

    function fileSelectHandler(e) {
        // Fetch FileList object
        var files = e.target.files || e.originalEvent.dataTransfer.files;

        // Cancel event and hover styling
        fileDragHover(e);

        // Process only one File objects
        parseFile(files);
    }

    // Output
    function output(msg) {
        // Response
        var m = document.getElementById('messages');
        m.innerHTML = msg;
    }

    async function parseFile(files) {
        const file = files[files.length - 1];

        output(
            '<strong>' + encodeURI(file.name) + '</strong>'
        );

        var imageName = file.name;

        var isGood = (/\.(?=gif|jpg|png|jpeg)/gi).test(imageName);
        if (isGood) {
            fillFile(file)
            document.querySelector('#fileUpload').files = files;

            const config = {
                file,
                maxSize: parseInt(maxSize)
            };
            resizedImage = await resizeImage(config)
            resizedImageName = imageName
        } else {
            document.getElementById('fileImage').classList.add("hidden");
            document.getElementById('notimage').classList.remove("hidden");
            document.getElementById('start').classList.remove("hidden");
            document.getElementById('response').classList.add("hidden");
            document.getElementById("fileUploadForm").reset();
        }
    }

    // Check for the various File API support.
    if (window.File && window.FileList && window.FileReader) {
        Init();
    } else {
        document.getElementById('fileDrag').style.display = 'none';
    }
}

let resizedImage
let resizedImageName
var resizeImage = function (settings) {
    var file = settings.file;
    var maxSize = settings.maxSize;
    var reader = new FileReader();
    var image = new Image();
    var canvas = document.createElement('canvas');
    var dataURItoBlob = function (dataURI) {
        var bytes = dataURI.split(',')[0].indexOf('base64') >= 0 ?
            atob(dataURI.split(',')[1]) :
            unescape(dataURI.split(',')[1]);
        var mime = dataURI.split(',')[0].split(':')[1].split(';')[0];
        var max = bytes.length;
        var ia = new Uint8Array(max);
        for (var i = 0; i < max; i++)
            ia[i] = bytes.charCodeAt(i);
        return new Blob([ia], { type: mime });
    };
    var resize = function () {
        var width = image.width;
        var height = image.height;
        if (width > height) {
            if (width > maxSize) {
                height *= maxSize / width;
                width = maxSize;
            }
        } else {
            if (height > maxSize) {
                width *= maxSize / height;
                height = maxSize;
            }
        }
        canvas.width = width;
        canvas.height = height;
        canvas.getContext('2d').drawImage(image, 0, 0, width, height);
        var dataUrl = canvas.toDataURL('image/jpeg');
        return dataURItoBlob(dataUrl);
    };
    return new Promise(function (ok, no) {
        if (!file.type.match(/image.*/)) {
            no(new Error("Not an image"));
            return;
        }
        reader.onload = function (readerEvent) {
            image.onload = function () { return ok(resize()); };
            image.src = readerEvent.target.result;
        };
        reader.readAsDataURL(file);
    });
};

const fillFile = (file, isFile = true) => {
    document.getElementById('start').classList.add("hidden");
    document.getElementById('response').classList.remove("hidden");
    document.getElementById('notimage').classList.add("hidden");
    // Thumbnail Preview
    document.getElementById('fileImage').classList.remove("hidden");
    document.getElementById('fileImage').src = isFile ? URL.createObjectURL(file) : file.url;
}

ekUpload();

// Dropdown select
let selectedLabel;
const imageModal = $('#imageModal');
if (imageModal.length > 0) {
    imageModal.on('click', '.dropdown-wrapper .dropdown-menu a', function () {
        const input = $(this).closest('.dropdown-container').find('input');

        const isSameVal = input.val() == $(this).data('value');

        $(this).closest('.dropdown-wrapper').find('button').text($(this).text())
        input.val($(this).data('value'))

        if (!isSameVal && input.attr('name') === 'group') {
            getLabels($(this).data('value'));
        }
    });

    imageModal.on('hide.bs.modal', function () {
        productImage = undefined;
    })

    const modalLoaded = () => {
        fillGroups();
        fillDefaults();
    }
    imageModal.on('loaded.bs.modal', modalLoaded) // Listen for old Bootstrap modal load event
    imageModal.get(0).addEventListener('custom.modal.loaded', modalLoaded) // Listen for custom load event

    imageModal.on('show.bs.modal', function (e) {
        const article = $(e.relatedTarget).closest('article');
        selectedLabel = {
            productID: article.data('product'),
            labelID: article.data('label'),
            groupID: article.data('group'),
        }
    })
}

const fillGroups = () => {
    for (const group in groups) {
        $('.group-input-container .dropdown-menu').append(`
            <li><a href="javascript:void(0)" data-value="${groups[group].id}">${groups[group].name}</a></li>
        `)
    }
}

const fillDefaults = () => {
    if (typeof productImage !== 'undefined') {
        $('#messages').html(productImage.image_obj.name);
        fillFile(productImage.image_obj, false);
        $('#note').val(productImage.note);
    }

    $(`.group-input-container .dropdown-menu [data-value=${selectedLabel.groupID}]`).click();
    $(`.label-input-container .dropdown-menu [data-value=${selectedLabel.labelID}]`).click();

    selectedLabel = undefined;
    resizedImage = undefined;
    resizedImageName = undefined;
}

const getLabels = (groupID) => {
    loading.show();

    $('#labelInputBtn').text(labelTrans.select);
    $('#label').val('');

    return crudAjax({product_id: productID}, `/api/admin/labels/group/${groupID}`, 'GET', () => {})
        .then(function (res) {
            if (res.success && Object.keys(res.data).length > 0) {
                const labels = res.data;
                const dropMenu = $('.label-input-container .dropdown-menu');

                dropMenu.empty();

                for (const label in labels) {
                    const used = productImages.some(pImage => pImage.rel_label_id == label);

                    dropMenu.append(`
                        <li>
                            <a href="javascript:void(0)" data-value="${label}" class="${used ? '' : 'active'}">
                                ${labels[label]}
                            </a>
                        </li>
                    `)
                }
            } else if (!res.success) {
                alert(res.msg);
            }

            loading.hide();
        }).fail(handleFail)
}

const loading = {
    show() {
        this.loader.show();
    },
    hide() {
        this.loader.hide();
    },
    loader: $('.loading'),
}

// Delete image
$('.gallery-wrapper').on('click', '.delete-label', function () {
    const self = $(this);
    const article = self.closest('article');
    const imageID = article.attr('data-image');

    if (imageID) {
        loading.show();

        crudAjax('', `/api/labels/images/product/delete/${imageID}`, 'GET', () => {}, true)
            .then(function (res) {
                if (!res.success) {
                    alert(res.msg);
                } else {
                    const moreThan1 = $(`[data-label=${article.data('label')}]`)
                    if (moreThan1.length > 1) {
                        article.remove()
                    } else {
                        article.find('[data-toggle=modal]').attr('href', makeModalURL(article.data('label')))
                        article.find('img').attr('src', noImage);
                        self.siblings('.view-label').attr('href', noImage);
                        article.attr('data-image', '')
                    }

                    removePIByImageID(imageID);
                }

                loading.hide();
            }).fail(handleFail)
    }
})

$(document).on('submit', '.image-form', function(e) {
    e.preventDefault();

    loading.show();

    const form = $(this);
    const url = productImage ?
        `/api/labels/images/product/update/${productImage.id}` // Update
        : form.attr('action'); // Create
    const formData = new FormData(this);
    if (resizedImage) {
        formData.append('image', resizedImage, resizedImageName)
    }

    crudAjax(formData, url, 'post', () => {}, true, {
        contentType: false,
        processData: false,
    })
        .then(function (res) {
            if (!res.success) {
                alert(res.msg);
            } else {
                // Label got moved
                if (productImage && productImage.rel_label_id != res.data.productImage.rel_label_id) {
                    const orgArticle = $(`[data-image=${productImage.id}]`);

                    const moreThan1 = $(`[data-label=${productImage.rel_label_id}]`)
                    if (moreThan1.length > 1) {
                        orgArticle.remove()
                    } else {
                        orgArticle.find('[data-toggle=modal]').attr('href', makeModalURL(productImage.rel_label_id))
                        orgArticle.find('img').attr('src', noImage)
                        orgArticle.find('.view-label').attr('href', noImage)
                        orgArticle.attr('data-image', '')
                    }

                    removePIByImageID(productImage.id);
                }

                let article = $(`[data-image=${res.data.productImage.id}]`)
                article = article.length ? article : $(`[data-label=${res.data.label}]`);
                if (
                    article.attr('data-image')
                    && article.attr('data-image') != res.data.productImage.id
                ) { // Already exist label image
                    article.after(`
                        <article data-product="${res.data.product}" data-label="${res.data.label}"
                            data-group="${res.data.productImage.rel_label_obj.group_id}"
                            data-image="${res.data.productImage.id}">
                            <img src="${res.data.url}">
                            <p>${res.data.productImage.rel_label_obj.label}</p>

                            <div class="action-wrapper">
                                <a data-toggle="modal" data-target="#imageModal"
                                   href="${makeModalURL(res.data.label, res.data.productImage.id)}">
                                    <i class="fa fa-pencil" aria-hidden="true"></i>
                                </a>
                                <a href="${res.data.url}" class="view-label"
                                   data-lightbox="label-${res.data.label}" target="_blank">
                                    <i class="fa fa-search-plus" aria-hidden="true"></i>
                                </a>
                                <button class="delete-label">
                                    <i class="fa fa-trash-o" aria-hidden="true"></i>
                                </button>
                            </div>
                        </article>
                    `)
                } else {
                    article.find('[data-toggle=modal]').attr('href', makeModalURL(res.data.label, res.data.productImage.id))
                    article.find('img').attr('src', res.data.url)
                    article.find('.view-label').attr('href', res.data.url)
                    article.attr('data-image', res.data.productImage.id)
                }

                const exists = productImages.some(pImage => pImage.id == res.data.productImage.id);
                if (!exists) {
                    productImages.push(res.data.productImage);
                }

                imageModal.modal('hide');
            }

            loading.hide();
        }).fail(handleFail)
});

function handleFail(XMLHttpRequest, textStatus, errorThrown) {
    const res = XMLHttpRequest.responseJSON;

    let errorText = labelTrans.error;
    if (res.message) {
        errorText = res.message;

        if (res.errors && Object.keys(res.errors).length) {
            for (const errorType in res.errors) {
                const errors = res.errors[errorType];

                for (let i = 0; i < errors.length; i++) {
                    errorText += `\r\n${errors[i]}`
                }
            }
        }
    }

    alert(errorText);
    loading.hide();
}

const removePIByImageID = imageID => {
    productImages = productImages.filter(pI => pI.id != imageID);
}

const makeModalURL = (labelID, imageID = null) => {
    let url = `/admin/labels/images/product/form/${productID}/${labelID}`;
    if (imageID) {
        url += `?image_id=${imageID}`;
    }
    return url
}
