<?php namespace Visiosoft\LabelsModule\Label;

use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class LabelRepository extends EntryRepository implements LabelRepositoryInterface
{
    protected $model;

    public function __construct(LabelModel $model)
    {
        $this->model = $model;
    }

    public function getByCategories($categories, $nonCategories = true)
    {
        $labels = $this->newQuery();

        if ($nonCategories) {
            $labels = $labels->doesntHave('categories');
        }

        return $labels
            ->orWhereHas('categories', function ($q) use ($categories) {
                $q->whereIn('related_id', $categories);
            })->get();
    }
}
