// File Upload
function ekUpload() {
    function Init() {
        $(document).on('change', '#fileUpload', fileSelectHandler);

        // Is XHR2 available?
        var xhr = new XMLHttpRequest();
        if (xhr.upload) {
            // File Drop
            $(document).on('dragover', '#fileDrag', fileDragHover);
            $(document).on('dragleave', '#fileDrag', fileDragHover);
            $(document).on('drop', '#fileDrag', fileSelectHandler);
        }
    }

    function fileDragHover(e) {
        var fileDrag = document.getElementById('fileDrag');

        e.stopPropagation();
        e.preventDefault();

        fileDrag.className = (e.type === 'dragover' ? 'mb-2 hover' : 'mb-2 modal-body file-upload');
    }

    function fileSelectHandler(e) {
        // Fetch FileList object
        var files = e.target.files || e.originalEvent.dataTransfer.files;

        // Cancel event and hover styling
        fileDragHover(e);

        // Process only one File objects
        parseFile(files);
    }

    // Output
    function output(msg) {
        // Response
        var m = document.getElementById('messages');
        m.innerHTML = msg;
    }

    function parseFile(files) {
        const file = files[files.length - 1];

        output(
            '<strong>' + encodeURI(file.name) + '</strong>'
        );

        var imageName = file.name;

        var isGood = (/\.(?=gif|jpg|png|jpeg)/gi).test(imageName);
        if (isGood) {
            fillFile(file)
            document.querySelector('#fileUpload').files = files;
        } else {
            document.getElementById('fileImage').classList.add("hidden");
            document.getElementById('notimage').classList.remove("hidden");
            document.getElementById('start').classList.remove("hidden");
            document.getElementById('response').classList.add("hidden");
            document.getElementById("fileUploadForm").reset();
        }
    }

    // Check for the various File API support.
    if (window.File && window.FileList && window.FileReader) {
        Init();
    } else {
        document.getElementById('fileDrag').style.display = 'none';
    }
}

const fillFile = (file, isFile = true) => {
    document.getElementById('start').classList.add("hidden");
    document.getElementById('response').classList.remove("hidden");
    document.getElementById('notimage').classList.add("hidden");
    // Thumbnail Preview
    document.getElementById('fileImage').classList.remove("hidden");
    document.getElementById('fileImage').src = isFile ? URL.createObjectURL(file) : file.url;
}

ekUpload();

// Dropdown select
const imageModal = $('#imageModal');
imageModal.on('click', '.dropdown-wrapper .dropdown-menu a', function () {
    const input = $(this).closest('.dropdown-container').find('input');

    const isSameVal = input.val() == $(this).data('value');

    $(this).closest('.dropdown-wrapper').find('button').text($(this).text())
    input.val($(this).data('value'))

    if (!isSameVal && input.attr('name') === 'group') {
        getLabels($(this).data('value'));
    }
});

imageModal.on('hide.bs.modal', function () {
    productImage = undefined;
})

imageModal.on('loaded.bs.modal', function () {
    fillGroups();
    fillDefaults();
})

let selectedLabel;
imageModal.on('show.bs.modal', function (e) {
    const article = $(e.relatedTarget).closest('article');
    selectedLabel = {
        productID: article.data('product'),
        labelID: article.data('label'),
        groupID: article.data('group'),
    }
})

const fillGroups = () => {
    for (const group in groups) {
        $('.group-input-container .dropdown-menu').append(`
            <li><a href="javascript:void(0)" data-value="${groups[group].id}">${groups[group].name}</a></li>
        `)
    }
}

const fillDefaults = () => {
    if (typeof productImage !== 'undefined') {
        $('#messages').html(productImage.image_obj.name);
        fillFile(productImage.image_obj, false);
        $('#note').val(productImage.note);
    }

    $(`.group-input-container .dropdown-menu [data-value=${selectedLabel.groupID}]`).click();
    $(`.label-input-container .dropdown-menu [data-value=${selectedLabel.labelID}]`).click();

    selectedLabel = undefined;
}

const getLabels = (groupID) => {
    loading.show();

    $('#labelInputBtn').text(labelTrans.select);
    $('#label').val('');

    return crudAjax('', `/api/admin/labels/group/${groupID}`, 'GET', () => {})
        .then(function (res) {
            if (res.success && Object.keys(res.data).length > 0) {
                const labels = res.data;
                const dropMenu = $('.label-input-container .dropdown-menu');

                dropMenu.empty();

                for (const label in labels) {
                    const used = productImages.some(pImage => pImage.rel_label_id == label);

                    dropMenu.append(`
                        <li>
                            <a href="javascript:void(0)" data-value="${label}" class="${used ? '' : 'active'}">
                                ${labels[label]}
                            </a>
                        </li>
                    `)
                }
            } else if (!res.success) {
                alert(res.msg);
            }

            loading.hide();
        }).fail(handleFail)
}

const loading = {
    show() {
        this.loader.show();
    },
    hide() {
        this.loader.hide();
    },
    loader: $('.loading'),
}

$('.delete-label').click(function () {
    loading.show();

    const self = $(this);
    const article = self.closest('article');
    const productID = article.data('product');
    const labelID = article.data('label');

    crudAjax('', `/admin/labels/images/product/delete/${productID}/${labelID}`, 'GET', () => {}, true)
        .then(function (res) {
            if (!res.success) {
                alert(res.msg);
            } else {
                article.find('img').attr('src', noImage);
                self.siblings('.view-label').attr('href', noImage);

                removePIByLabelID(labelID);

                alert(labelTrans.success);
            }

            loading.hide();
        }).fail(handleFail)
})

imageModal.on('submit', '#imageForm', function(e) {
    e.preventDefault();

    loading.show();

    const form = $(this);
    const url = form.attr('action');
    const formData = new FormData(this);

    crudAjax(formData, url, 'post', () => {}, true, {
        contentType: false,
        processData: false,
    })
        .then(function (res) {
            if (!res.success) {
                alert(res.msg);
            } else {
                const article = $(`[data-product=${res.data.product}][data-label=${res.data.label}]`);
                article.find('img').attr('src', res.data.url)
                article.find('.view-label').attr('href', res.data.url)

                // Label got moved
                if (productImage && productImage.rel_label_id != res.data.productImage.rel_label_id) {
                    const orgArticle = $(`[data-product=${res.data.product}][data-label=${productImage.rel_label_id}]`);
                    orgArticle.find('img').attr('src', noImage)
                    orgArticle.find('.view-label').attr('href', noImage)
                    removePIByLabelID(productImage.rel_label_id);
                }

                const exists = productImages.some(pImage => pImage.rel_label_id == res.data.productImage.rel_label_id);
                if (!exists) {
                    productImages.push(res.data.productImage);
                }

                alert(labelTrans.success);

                imageModal.modal('hide');
            }

            loading.hide();
        }).fail(handleFail)
});

function handleFail(XMLHttpRequest, textStatus, errorThrown) {
    const res = XMLHttpRequest.responseJSON;

    let errorText = labelTrans.error;
    if (res.message) {
        errorText = res.message;

        if (res.errors && Object.keys(res.errors).length) {
            for (const errorType in res.errors) {
                const errors = res.errors[errorType];

                for (let i = 0; i < errors.length; i++) {
                    errorText += `\r\n${errors[i]}`
                }
            }
        }
    }

    alert(errorText);
    loading.hide();
}

const removePIByLabelID = labelID => {
    productImages = productImages.filter(pI => pI.rel_label_id != labelID);
}
