<?php namespace Visiosoft\LabelsModule\Listeners;

use Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying;
use Illuminate\Contracts\Container\Container;
use Visiosoft\AdvsModule\Adv\Table\AdvTableBuilder;

class AddLabelsButton
{
    protected $container;

    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    public function handle(TableIsQuerying $event)
    {
        $builder = $event->getBuilder();

        if (get_class($builder) == AdvTableBuilder::class) {
            $buttons = $builder->getButtons();

            if (is_string($buttons)) {
                $buttons = $this->container->call($buttons);
            }

            if (isset($buttons['settings'])) {
                $dropdown = array_merge($buttons['settings']['dropdown'], [
                    "labels" => [
                        "text" => trans('visiosoft.module.labels::button.add_labels'),
                        "href" => "/admin/labels/images/product/create/{entry.id}"
                    ]
                ]);
                $buttons['settings']['dropdown'] = $dropdown;
                $builder->setButtons($buttons);
            }
        }
    }
}
