<?php namespace Visiosoft\LabelsModule\Label\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class LabelTableBuilder extends TableBuilder
{
    protected $filters = [
        'label',
        'group',
    ];

    protected $columns = [
        'entry.id',
        'entry.sort_order',
        'label',
        'group',
        'entry.required.text',
        'entry.rating.text',
    ];

    protected $buttons = [
        'categories' => [
            'icon' => 'fa fa-exclamation',
            'type' => 'info',
            'text' => '',
            'data-toggle' => 'modal',
            'data-target' => '#modal',
            'href'        => 'admin/labels/choose/{entry.id}',
        ],
        'edit' => [
            'text' => ''
        ],
    ];

    protected $actions = [
        'delete'
    ];
}
