<?php namespace Visiosoft\LabelsModule\Image\Command;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\LabelsModule\Image\Contract\ImageRepositoryInterface;

class GetProductImages
{
    use DispatchesJobs;

    private $productID;

    public function __construct($productID)
    {
        $this->productID = $productID;
    }

    public function handle(ImageRepositoryInterface $imageRepository)
    {
        return $imageRepository->findAllBy('product_id', $this->productID);
    }
}
