<?php namespace Visiosoft\LabelsModule\Http\View\Composers;

use Illuminate\View\View;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\LabelsModule\Image\Contract\ImageRepositoryInterface;
use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;

class LabelComposer
{
    private $advRepository;
    private $imageRepository;
    private $labelRepository;

    public function __construct(
        AdvRepositoryInterface $advRepository,
        ImageRepositoryInterface $imageRepository,
        LabelRepositoryInterface $labelRepository
    )
    {
        $this->advRepository = $advRepository;
        $this->imageRepository = $imageRepository;
        $this->labelRepository = $labelRepository;
    }

    public function compose(View $view)
    {
        $view->with($this->labels($view->getData()['id']));
    }

    public function labels($productID)
    {
        $ad = $this->advRepository->getModel()->findOrFail($productID);

        $this->checkAd($ad);

        $categories = array();
        for ($i = 1; $i <= 10; $i++) {
            if ($ad["cat$i"]) {
                $categories["cat$i"] = $ad["cat$i"];
            }
        }

        $labels = $this->labelRepository->getByCategories($categories);

        $adImages = $this->imageRepository->getByProductID($productID);

        $groups = collect();
        $labelGroups = $labels->groupBy('group_id');
        foreach ($labelGroups as $group) {
            $group = $group->first()->group;
            $groups->add($group);
        }
        $groups = $groups->sortBy('sort_order');

        return compact('labels', 'groups', 'adImages');
    }

    protected function checkAd($ad)
    {
        if (!$ad->canEdit()) {
            abort(404);
        }
    }
}
