<?php namespace Visiosoft\LabelsModule\Http\Controller\Admin;

use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;
use Visiosoft\LabelsModule\Label\Form\LabelFormBuilder;
use Visiosoft\LabelsModule\Label\Table\LabelTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class LabelsController extends AdminController
{
    private $labelRepository;

    public function __construct(LabelRepositoryInterface $labelRepository)
    {
        parent::__construct();
        $this->labelRepository = $labelRepository;
    }

    public function index(LabelTableBuilder $table)
    {
        return $table->render();
    }

    public function choose($labelID)
    {
        $label = $this->labelRepository->find($labelID);

        $categories = implode(', ', $label->categories->pluck('name')->all());

        return $this->view->make('visiosoft.module.labels::admin/labels/choose', ['categories' => $categories]);
    }

    public function create(LabelFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(LabelFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function groupLabels($groupID)
    {
        try {
            return [
                'success' => true,
                'data' => $this->labelRepository->findAllBy('group_id', $groupID)
                    ->pluck('label', 'id')
                    ->all()
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }
}
