<?php namespace Visiosoft\LabelsModule\Group\Command;

use Visiosoft\LabelsModule\Group\Contract\GroupInterface;
use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;

class CheckUsage
{
    protected $group;

    public function __construct(GroupInterface $group)
    {
        $this->group = $group;
    }

    public function handle(LabelRepositoryInterface $labelRepository)
    {
        $labels = $labelRepository->findAllBy('group_id', $this->group->id);

        if (count($labels)) {
            $labelsIDs = implode(', ', $labels->pluck('id')->all());
            return trans(
                'visiosoft.module.labels::field.group_is_used_in_the_following_labels',
                ['groupName' => $this->group->name, 'labelsIDs' => $labelsIDs]
            );
        }

        return false;
    }
}
