<?php namespace Visiosoft\LabelsModule\Label;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;
use Visiosoft\LabelsModule\Label\Command\CheckUsage;

class LabelObserver extends EntryObserver
{
    protected $messages;

    public function __construct()
    {
        parent::__construct();
        $this->messages = app('Anomaly\Streams\Platform\Message\MessageBag');
    }

    public function deleting(EntryInterface $entry)
    {
        if ($message = $this->dispatch(new CheckUsage($entry))) {
            $this->messages->error($message);

            return false;
        }

        parent::deleting($entry);
    }
}
