<?php namespace Visiosoft\LabelsModule\Http\Controller\Admin;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;
use Visiosoft\LabelsModule\Label\Form\LabelFormBuilder;
use Visiosoft\LabelsModule\Label\Table\LabelTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class LabelsController extends AdminController
{
    private $labelRepository;

    public function __construct(LabelRepositoryInterface $labelRepository)
    {
        parent::__construct();
        $this->labelRepository = $labelRepository;
    }

    public function index(LabelTableBuilder $table)
    {
        return $table->render();
    }

    public function choose($labelID)
    {
        $label = $this->labelRepository->find($labelID);

        $categories = implode(', ', $label->categories->pluck('name')->all());

        return $this->view->make('visiosoft.module.labels::admin/labels/choose', ['categories' => $categories]);
    }

    public function create(LabelFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(LabelFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function groupLabels(AdvRepositoryInterface $advRepository, $groupID)
    {
        $labels = $this->labelRepository->findAllBy('group_id', $groupID);

        if (($productID = request('product_id')) && ($product = $advRepository->find($productID))) {
            $cats = $product->getCatsIDs();

            if (count($cats)) {
                foreach ($labels as $index => $label) {
                    if (count($label->categories) && !$label->categories->whereIn('id', array_values($cats))->count()) {
                        unset($labels[$index]);
                    }
                }
            }
        }

        try {
            return [
                'success' => true,
                'data' => $labels->pluck('label', 'id')->all()
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }
}
