<?php namespace Visiosoft\LabelsModule\Http\Controller\Admin;

use Anomaly\FilesModule\File\FileUploader;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\LabelsModule\Image\Contract\ImageRepositoryInterface;
use Visiosoft\LabelsModule\Image\Form\ImageFormBuilder;
use Visiosoft\LabelsModule\Image\Table\ImageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;

class ImagesController extends AdminController
{
    private $advRepository;
    private $imageRepository;

    public function __construct(AdvRepositoryInterface $advRepository, ImageRepositoryInterface $imageRepository)
    {
        parent::__construct();
        $this->advRepository = $advRepository;
        $this->imageRepository = $imageRepository;
    }

    public function index(ImageTableBuilder $table)
    {
        return $table->render();
    }

    public function create(ImageFormBuilder $form)
    {
        return $form->render();
    }

    public function productCreate(LabelRepositoryInterface $labelRepository, $productID)
    {
        $ad = $this->advRepository->getModel()->findOrFail($productID);

        $categories = array();
        for ($i = 1; $i <= 10; $i++) {
            if ($ad["cat$i"]) {
                $categories["cat$i"] = $ad["cat$i"];
            }
        }

        $labels = $labelRepository->getByCategories($categories);

        $adImages = $this->imageRepository->getByProductID($productID);

        $labels = $labels->map(function ($item, $key) use ($adImages) {
            $images = $adImages->where('rel_label_id', $item->id);
            $item->images = $images;
            return $item;
        });

        $groups = collect();
        $labelGroups = $labels->groupBy('group_id');
        foreach ($labelGroups as $group) {
            $group = $group->first()->group;
            $groups->add($group);
        }
        $groups = $groups->sortBy('sort_order');

        return view(
            'visiosoft.module.labels::admin/images/product/create',
            compact('labels', 'groups', 'adImages')
        );
    }

    public function form($productID, $labelID)
    {
        $imageID = request('image_id');
        $image = $imageID ?
            $this->imageRepository->find($imageID)
            : $this->imageRepository->findByLabelAndProduct($labelID, $productID);
        if ($image) {
            $image->image_obj = [
                'name' => $image->image->name,
                'url' => $image->image->make()->url(),
            ];
        }

        return $this->view->make(
            'visiosoft.module.labels::admin/images/product/form',
            compact('productID', 'image')
        );
    }

    public function edit(ImageFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
