<?php namespace Visiosoft\LabelsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Ui\Table\Event\TableIsQuerying;
use Visiosoft\LabelsModule\Group\Contract\GroupRepositoryInterface;
use Visiosoft\LabelsModule\Group\GroupRepository;
use Anomaly\Streams\Platform\Model\Labels\LabelsGroupsEntryModel;
use Visiosoft\LabelsModule\Group\GroupModel;
use Visiosoft\LabelsModule\Image\Contract\ImageRepositoryInterface;
use Visiosoft\LabelsModule\Image\ImageRepository;
use Anomaly\Streams\Platform\Model\Labels\LabelsImagesEntryModel;
use Visiosoft\LabelsModule\Image\ImageModel;
use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;
use Visiosoft\LabelsModule\Label\LabelRepository;
use Anomaly\Streams\Platform\Model\Labels\LabelsLabelsEntryModel;
use Visiosoft\LabelsModule\Label\LabelModel;
use Visiosoft\LabelsModule\Listeners\AddLabelsButton;

class LabelsModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        LabelsModulePlugin::class,
    ];

    protected $routes = [
        // Admin GroupsController
        'admin/labels/groups'           => 'Visiosoft\LabelsModule\Http\Controller\Admin\GroupsController@index',
        'admin/labels/groups/create'    => 'Visiosoft\LabelsModule\Http\Controller\Admin\GroupsController@create',
        'admin/labels/groups/edit/{id}' => 'Visiosoft\LabelsModule\Http\Controller\Admin\GroupsController@edit',

        // Admin ImagesController
        'admin/labels/images'                                        => 'Visiosoft\LabelsModule\Http\Controller\Admin\ImagesController@index',
        'admin/labels/images/create'                                 => 'Visiosoft\LabelsModule\Http\Controller\Admin\ImagesController@create',
        'admin/labels/images/product/create/{product_id}'            => 'Visiosoft\LabelsModule\Http\Controller\Admin\ImagesController@productCreate',
        'admin/labels/images/product/form/{product_id}/{label_id}'   => 'Visiosoft\LabelsModule\Http\Controller\Admin\ImagesController@form',
        'admin/labels/images/product/delete/{product_id}/{label_id}' => 'Visiosoft\LabelsModule\Http\Controller\Admin\ImagesController@delete',
        'admin/labels/images/edit/{id}'                              => 'Visiosoft\LabelsModule\Http\Controller\Admin\ImagesController@edit',

        // ImagesController
        'advs/edit-advs/labels/{product_id}'           => [
            'middleware' => 'auth',
            'uses' => 'Visiosoft\LabelsModule\Http\Controller\ImagesController@labels',
        ],
        'api/labels/images/product/store/{product_id}' => [
            'middleware' => 'auth',
            'uses' => 'Visiosoft\LabelsModule\Http\Controller\ImagesController@store',
        ],

        // Admin LabelsController
        'admin/labels'                      => 'Visiosoft\LabelsModule\Http\Controller\Admin\LabelsController@index',
        'admin/labels/create'               => 'Visiosoft\LabelsModule\Http\Controller\Admin\LabelsController@create',
        'admin/labels/edit/{id}'            => 'Visiosoft\LabelsModule\Http\Controller\Admin\LabelsController@edit',
        'api/admin/labels/group/{group_id}' => 'Visiosoft\LabelsModule\Http\Controller\Admin\LabelsController@groupLabels',
    ];

    protected $listeners = [
        TableIsQuerying::class => [
            AddLabelsButton::class
        ]
    ];

    protected $bindings = [
        LabelsGroupsEntryModel::class => GroupModel::class,
        LabelsImagesEntryModel::class => ImageModel::class,
        LabelsLabelsEntryModel::class => LabelModel::class,
    ];

    protected $singletons = [
        GroupRepositoryInterface::class => GroupRepository::class,
        ImageRepositoryInterface::class => ImageRepository::class,
        LabelRepositoryInterface::class => LabelRepository::class,
    ];
}
