<?php namespace Visiosoft\LabelsModule\Image;

use Visiosoft\LabelsModule\Image\Contract\ImageRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ImageRepository extends EntryRepository implements ImageRepositoryInterface
{
    protected $model;

    public function __construct(ImageModel $model)
    {
        $this->model = $model;
    }

    public function getByProductID($productID)
    {
        return $this->findAllBy('product_id', $productID);
    }

    public function findByLabelAndProduct($labelID, $productID)
    {
        return $this->getModel()->where([
            'rel_label_id' => $labelID,
            'product_id' => $productID
        ])->first();
    }
}
