<?php namespace Visiosoft\LabelsModule\Http\Controller\Admin;

use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\LabelsModule\Image\Form\ImageFormBuilder;
use Visiosoft\LabelsModule\Image\Table\ImageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;

class ImagesController extends AdminController
{
    public function index(ImageTableBuilder $table)
    {
        return $table->render();
    }

    public function create(ImageFormBuilder $form)
    {
        return $form->render();
    }

    public function productCreate(AdvRepositoryInterface $advRepository, LabelRepositoryInterface $labelRepository, $productID)
    {
        $ad = $advRepository->getModel()->findOrFail($productID);

        $categories = array();
        for ($i = 1; $i <= 10; $i++) {
            if ($ad["cat$i"]) {
                $categories["cat$i"] = $ad["cat$i"];
            }
        }

        $labels = $labelRepository->newQuery()
            ->doesntHave('categories')
            ->orWhereHas('categories', function ($q) use ($categories) {
                $q->whereIn('related_id', $categories);
            })->get();

        return view(
            'visiosoft.module.labels::admin/images/product/create',
            compact('labels')
        );
    }

    public function form(ImageFormBuilder $form)
    {
        return $this->view->make('visiosoft.module.labels::admin/images/product/form', ['form' => $form]);
    }

    public function edit(ImageFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
