// File Upload
function ekUpload(){
    function Init() {
        $(document).on('change', '#fileUpload', fileSelectHandler);

        // Is XHR2 available?
        var xhr = new XMLHttpRequest();
        if (xhr.upload) {
            // File Drop
            $(document).on('dragover', '#fileDrag', fileDragHover);
            $(document).on('dragleave', '#fileDrag', fileDragHover);
            $(document).on('drop', '#fileDrag', fileSelectHandler);
        }
    }

    function fileDragHover(e) {
        var fileDrag = document.getElementById('fileDrag');

        e.stopPropagation();
        e.preventDefault();

        fileDrag.className = (e.type === 'dragover' ? 'hover' : 'modal-body file-upload');
    }

    function fileSelectHandler(e) {
        // Fetch FileList object
        var files = e.target.files || e.originalEvent.dataTransfer.files;

        // Cancel event and hover styling
        fileDragHover(e);

        // Process all File objects
        for (var i = 0, f; f = files[i]; i++) {
            parseFile(f);
        }
    }

    // Output
    function output(msg) {
        // Response
        var m = document.getElementById('messages');
        m.innerHTML = msg;
    }

    function parseFile(file) {
        output(
            '<strong>' + encodeURI(file.name) + '</strong>'
        );

        var imageName = file.name;

        var isGood = (/\.(?=gif|jpg|png|jpeg)/gi).test(imageName);
        if (isGood) {
            document.getElementById('start').classList.add("hidden");
            document.getElementById('response').classList.remove("hidden");
            document.getElementById('notimage').classList.add("hidden");
            // Thumbnail Preview
            document.getElementById('fileImage').classList.remove("hidden");
            document.getElementById('fileImage').src = URL.createObjectURL(file);
        }
        else {
            document.getElementById('fileImage').classList.add("hidden");
            document.getElementById('notimage').classList.remove("hidden");
            document.getElementById('start').classList.remove("hidden");
            document.getElementById('response').classList.add("hidden");
            document.getElementById("fileUploadForm").reset();
        }
    }

    // Check for the various File API support.
    if (window.File && window.FileList && window.FileReader) {
        Init();
    } else {
        document.getElementById('fileDrag').style.display = 'none';
    }
}
ekUpload();
