<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleLabelsCreateLabelsFields extends Migration
{
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'label' => 'anomaly.field_type.text',
        "group" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\LabelsModule\Group\GroupModel::class,
                "mode"    => "search",
            ]
        ],
        "required" => [
            'type' => "anomaly.field_type.boolean",
            'config' => [
                'on_text' => 'visiosoft.module.labels::field.yes',
                'off_text' => 'visiosoft.module.labels::field.no',
            ]
        ],
        "rating" => [
            'type' => "anomaly.field_type.boolean",
            'config' => [
                'on_text' => 'visiosoft.module.labels::field.yes',
                'off_text' => 'visiosoft.module.labels::field.no',
            ]
        ],
        "categories" => [
            "type"   => "visiosoft.field_type.various",
            "config" => [
                "related" => \Visiosoft\CatsModule\Category\CategoryModel::class,
                "mode"    => "lookup",
            ]
        ],
        "image" => [
            "type"   => "visiosoft.field_type.singlefile",
            "config" => [
                "folders" => ['images'],
                "mode"    => "upload",
            ]
        ],
        "rel_label" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\LabelsModule\Label\LabelModel::class,
                "mode"    => "search",
            ]
        ],
        "note" => "anomaly.field_type.textarea",
        "product" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\AdvsModule\Adv\AdvModel::class,
                "mode"    => "search",
            ]
        ],
    ];
}
