<?php namespace Visiosoft\LabelsModule\Http\Controller\Admin;

use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;
use Visiosoft\LabelsModule\Label\Form\LabelFormBuilder;
use Visiosoft\LabelsModule\Label\Table\LabelTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class LabelsController extends AdminController
{
    public function index(LabelTableBuilder $table)
    {
        return $table->render();
    }

    public function create(LabelFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(LabelFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function groupLabels(LabelRepositoryInterface $labelRepository, $groupID)
    {
        try {
            return [
                'success' => true,
                'data' => $labelRepository->findAllBy('group_id', $groupID)
                    ->pluck('label', 'id')
                    ->all()
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }
}
