<?php namespace Visiosoft\LabelsModule\Http\Controller\Admin;

use Anomaly\FilesModule\File\FileUploader;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\LabelsModule\Image\Contract\ImageRepositoryInterface;
use Visiosoft\LabelsModule\Image\Form\ImageFormBuilder;
use Visiosoft\LabelsModule\Image\Table\ImageTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\LabelsModule\Label\Contract\LabelRepositoryInterface;

class ImagesController extends AdminController
{
    private $advRepository;
    private $imageRepository;

    public function __construct(AdvRepositoryInterface $advRepository, ImageRepositoryInterface $imageRepository)
    {
        parent::__construct();
        $this->advRepository = $advRepository;
        $this->imageRepository = $imageRepository;
    }

    public function index(ImageTableBuilder $table)
    {
        return $table->render();
    }

    public function create(ImageFormBuilder $form)
    {
        return $form->render();
    }

    public function productCreate(LabelRepositoryInterface $labelRepository, $productID)
    {
        $ad = $this->advRepository->getModel()->findOrFail($productID);

        $categories = array();
        for ($i = 1; $i <= 10; $i++) {
            if ($ad["cat$i"]) {
                $categories["cat$i"] = $ad["cat$i"];
            }
        }

        $labels = $labelRepository->newQuery()
            ->doesntHave('categories')
            ->orWhereHas('categories', function ($q) use ($categories) {
                $q->whereIn('related_id', $categories);
            })->get();

        $adImages = $this->imageRepository->findAllBy('product_id', $productID);

        $groups = array();
        $labelGroups = $labels->groupBy('group_id');
        foreach ($labelGroups as $group) {
            $group = $group->first()->group;
            $groups[$group->id] = $group->name;
        }

        return view(
            'visiosoft.module.labels::admin/images/product/create',
            compact('labels', 'groups', 'adImages')
        );
    }

    public function form($productID, $labelID)
    {
        if ($image = $this->imageRepository->getModel()->where([
            'rel_label_id' => $labelID,
            'product_id' => $productID
        ])->first()) {
            $image->rel_label_obj = $image->rel_label;
            $image->image_obj = [
                'name' => $image->image->name,
                'url' => $image->image->make()->url(),
            ];
        }

        return $this->view->make(
            'visiosoft.module.labels::admin/images/product/form',
            compact('productID', 'image')
        );
    }

    public function delete($productID, $labelID)
    {
        try {
            $this->imageRepository->getModel()->where([
                'rel_label_id' => $labelID,
                'product_id' => $productID
            ])->delete();

            return [
                'success' => true,
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage(),
            ];
        }
    }

    public function store($productID)
    {
        request()->validate([
            'group' => 'required|exists:labels_groups,id',
            'label' => 'required|exists:labels_labels,id',
        ]);

        $productImage = null;
        if (request('product_image')) {
            $productImage = $this->imageRepository->find(request()->product_image);
        }

        if (!$productImage && !$this->imageRepository->getModel()->where([
            'rel_label_id' => request('label'),
            'product_id' => $productID
        ])->first()) {
            request()->validate([
                'image' => 'required',
            ]);
        }

        try {
            if (!$this->advRepository->find($productID)) {
                throw new \Exception('Ad not found!');
            }

            $data = ['note' => request('note')];

            if ($this->request->file('image')) {
                $image = $this->upload();
                $data['image'] = $image;
            } elseif ($productImage) {
                $image = $productImage->image;
                $data['image'] = $image;
            }

            $productImage = $this->imageRepository->getModel()->updateOrCreate(
                [
                    'rel_label_id' => request('label'),
                    'product_id' => $productID
                ],
                $data
            );

            return [
                'success' => true,
                'data' => [
                    'url' => $image->make()->url(),
                    'product' => $productID,
                    'label' => request('label'),
                    'productImage' => $productImage,
                ]
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }

    private function upload()
    {
        $uploader = app(FileUploader::class);
        $folders = app(FolderRepositoryInterface::class);
        $folder = $folders->findBySlug('images');

        if ($file = $uploader->upload(
            $this->request->file('image'),
            $folder
        )
        ) {
            return $file;
        }

        throw new \Exception('An error occurred!');
    }

    public function edit(ImageFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
