<?php namespace Visiosoft\LabelsModule\Image\Command;

use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Illuminate\Foundation\Bus\DispatchesJobs;

class GetProductImage
{
    use DispatchesJobs;

    private $adImages;
    private $label;

    public function __construct($adImages, $label)
    {
        $this->adImages = $adImages;
        $this->label = $label;
    }

    public function handle()
    {
        if ($image = $this->adImages->findBy('rel_label_id', $this->label->id)) {
            return $image->image->make()->url();
        }

        return $this->dispatchNow(
            new MakeImageInstance(
                'visiosoft.theme.base::images/no-image.png',
                'img'
            )
        )->url();
    }
}
