<?php namespace Visiosoft\KitapTheme;

use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Anomaly\Streams\Platform\Ui\ControlPanel\Component\Navigation\Contract\NavigationLinkInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class KitapThemePlugin extends Plugin
{

    private $userRepository;


    private $linkRepo;
    public function __construct(
        UserRepositoryInterface $userRepository,
        LinkRepositoryInterface $linkRepo
    )
    {
        $this->userRepository = $userRepository;
        $this->linkRepo = $linkRepo;
    }
    public function getFunctions(): array
    {
        return [
            new \Twig_SimpleFunction(
                'getSubMenuByParentMenuId',
                function ($id) {
                    $submenus = $this->linkRepo->newQuery()
                        ->where('parent_id','=',null)
                        ->where('menu_id',$id)->get();

                    return $submenus;
                }
            ),
        ];
    }
}
