<?php

return [
    "facebook" => [
        "type"   => "anomaly.field_type.url"
    ],
    "twitter" => [
        "type"   => "anomaly.field_type.url"
    ],
    "instagram" => [
        "type"   => "anomaly.field_type.url"
    ],
    "contact_mail" => "anomaly.field_type.text",
    "logo" => [
        "type"   => "anomaly.field_type.file",
        "config" => [
            "folders" => ['images'],
        ]
    ],
    "theme_primary_color" => [
        "type"   => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#116839',
        ]
    ],
    "theme_secondary_color" => [
        "type"   => "anomaly.field_type.colorpicker",
        "config" => [
            "default_value" => '#0a4f28',
        ]
    ],
    'background_img' => [
        'type' => 'anomaly.field_type.file',
    ],
    'description_active' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    "ad_detail_color_scheme" => [
        "type" => "anomaly.field_type.colorpicker",
        'config' => [
            'default_value' => '#fff'
        ]
    ],
    "enable_lazy_loading" => [
        "type" => "anomaly.field_type.boolean",
        "config" => [
            "default_value" => true,
            "mode" => 'checkbox',
        ]
    ],
    'home_ad_height' => [
        'type' => 'anomaly.field_type.integer',
        'warning' => "100px default",
        'config' => [
            'min' => 40,
            'default_value' => 100
        ],
    ],
    'show_banner' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => true,
        ]
    ],
    'banner_mobile' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'banner_web_link' => [
        'type' => 'anomaly.field_type.url',
        'config' => [
            'default_value' => '#',
        ],
    ],
    'banner_mobile_link' => [
        'type' => 'anomaly.field_type.url',
        'config' => [
            'default_value' => '#',
        ],
    ],
    'banner_link_new_tab' => [
        'type' => 'anomaly.field_type.boolean',
        "config" => [
            "default_value" => true,
        ]
    ],
    'home_bottom_mobile' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],
    'banner_web' => [
        'type' => 'anomaly.field_type.file',
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    'free_shipping_cost' => [
        'type' => 'anomaly.field_type.decimal',
        'warning' => "Amount for free shipping",
        'config' => [
            'default_value' => 100
        ],
    ],
    'left_categories_banner' => [
        'type' => 'anomaly.field_type.wysiwyg',
    ],
];
