<?php namespace Visiosoft\KitapTheme;

use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Anomaly\Streams\Platform\Ui\ControlPanel\Component\Navigation\Contract\NavigationLinkInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class KitapThemePlugin extends Plugin
{

    private $userRepository;


    private $linkRepo;
    public function __construct(
        UserRepositoryInterface $userRepository,
        LinkRepositoryInterface $linkRepo
    )
    {
        $this->userRepository = $userRepository;
        $this->linkRepo = $linkRepo;
    }
    public function getFunctions(): array
    {
        return [
            new \Twig_SimpleFunction(
                'getSubMenuByParentMenuId',
                function ($id) {
                    $submenus = $this->linkRepo->newQuery()
                        ->where('parent_id','=',null)
                        ->where('menu_id',$id)->get();

                    return $submenus;
                }
            ),
            // TODO: move this function to adv and refactor
            new \Twig_SimpleFunction(
                'getItemStore',
                function (int $itemId) {
                    $storeRepository = app(StoreRepositoryInterface::class);
                    $store = $storeRepository->findBy('user_id', $itemId);
                    return $store;
                }
            )
        ];
    }
}
