/* Main scripts */

$(function () {
    $('[data-toggle="tooltip"]').tooltip()
})
/* End Main scripts */

/* Desktop header */
$('.header-search-book').focus(function () { // Search input focus
    $('.header-search-container').addClass('focused')
    $('.search-overlay').show()
})

$('.header-search-container button').hover(function () { // Change header search input border
    $('input[name=keyword]').toggleClass('hovered')
})

$('.search-overlay, .top-wrapper img').click(function () { // Hide focus & overlay
    $('.header-search-container').removeClass('focused')
    $('.styled-mobile-menu').css({top: '100vh', 'z-index': 'initial'})
    $('.search-overlay').hide()
    $('body').css({overflow: 'initial'})
})

$('.horizontal-menu-item').hover(function () { // Toggle horizontal menu mask
    if ($(this).is(":hover")) {
        $('.horizontal-menu-mask').show()
    } else {
        $('.horizontal-menu-mask').hide()
    }
})
/* End Desktop header */

/* Mobile header */
$('.mobile-menu-toggler').click(function () { // Show mobile navigation
    $('.styled-mobile-menu').css({top: '5rem', 'z-index': 9999})
    $('body').css({overflow: 'hidden'})
    $('.search-overlay').show()

    $('.mobile-menu-heading').click(function () { // Toggle mobile menu heading
        $(this).parent().toggleClass('minimized')
    })
})

$('.quick-browse-toggle-btn').click(function () { // Toggle show more quick browse links
    if ($(this).hasClass('toggled')) {
        $(this).removeClass('toggled').children('button').text(transSeeAll)
        $('.mobile-menu-list').css({height: '144px'})
    } else {
        $(this).addClass('toggled').children('button').text(transSeeLess)
        $('.mobile-menu-list').css({height: 'initial'})
    }
})

// Expand/Minimize & show/hide sub categories
$('.categories-accordion').on('click', '.categories-accordion-item', function () {
    const clickedItem = $(this)
    if (clickedItem.parent().hasClass('expand')) {
        clickedItem.parent().removeClass('expand')
        clickedItem.siblings('.categories-accordion-panel').hide()
    } else {
        let categoryId = clickedItem.attr('id')
        if (typeof categoryId !== 'undefined' && categoryId !== false) {
            categoryId = categoryId.substring(3)
            $.ajax({
                type: 'get',
                url: '/class/getcats/'+ categoryId,
                success: function (response) {
                    response.forEach(function (category, index) {
                        if (!category.hasChild) {
                            clickedItem.siblings('.categories-accordion-panel').append(`
                                <div>
                                    <a href="/c/${category.slug}" class="link-unstyled d-flex align-items-center justify-content-between categories-accordion-item">
                                        <p class="text-truncate">${category.name}</p>
                                    </a>
                                </div>
                            `)
                        } else {
                            clickedItem.siblings('.categories-accordion-panel').append(`
                                <div>
                                    <div id="cat${category.id}" class="d-flex align-items-center justify-content-between categories-accordion-item">
                                        <p class="text-truncate">${category.name}</p>
                                        <img src="${downloadSVG}" alt="arrow">
                                    </div>
                                    <div class="categories-accordion-panel"></div>
                                </div>
                            `)
                        }

                    })
                    clickedItem.parent().addClass('expand').siblings().removeClass('expand')
                        .children('.categories-accordion-panel').hide()
                    clickedItem.removeAttr('id').siblings('.categories-accordion-panel').show()
                }
            })
        } else {
            clickedItem.parent().addClass('expand').siblings().removeClass('expand')
                .children('.categories-accordion-panel').hide()
            clickedItem.siblings('.categories-accordion-panel').show()
        }
    }
})

$('.slider-4').slick({
    infinite: true,
    slidesToShow: 4,
    autoplay: true,
    centerMode: true,
    speed: 750,
    autoplaySpeed: 2500,
    swipeToSlide: true,
    arrows: true,
    prevArrow: `<img class="slick-prev"  src="${slick_prev_img}">`,
    nextArrow: `<img class="slick-next"  src="${slick_next_img}">`,
    responsive: [
        {
            breakpoint: 992,
            settings: {
                slidesToShow: 3,

            }
        },
        {
            breakpoint: 768,
            settings: {
                slidesToShow: 2,
                centerMode: false,
            }
        }
    ]
});

/* End Mobile header */

