(function (window, document) {

    let fields = Array.prototype.slice.call(
        document.querySelectorAll('input[name="created_at"]:not(.flatpickr-input)')
    );

    fields.forEach(function (field) {
        field.flatpickr({
            altInput: true,
            allowInput: true,
            locale: field.getAttribute('data-locale'),
            altFormat: field.getAttribute('data-alt-format'),
            altInputClass: 'flatpickr-input ' + field.className,
            minuteIncrement: field.getAttribute('data-step') || 1,
        });
    });
})(window, document);
