<?php namespace Visiosoft\KariyerModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;


class KariyerModuleSeeder extends Seeder
{

    public function run(
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        StreamRepositoryInterface $streamRepository,
        DiskRepositoryInterface $disks,
        FolderRepositoryInterface $folders
    )
    {
        if (is_module_installed('visiosoft.module.customfields')) {
            $customFieldRepository = app(CustomFieldRepositoryInterface::class);
            $customFieldRepository->newQuery()->firstOrCreate(
                ['slug' => 'is_turu'],
                ['name' => 'İş Türü', 'type' => 'select']
            );

            $customFieldRepository->newQuery()->firstOrCreate(
                ['slug' => 'is_ilaninin_dili'],
                ['name' => 'İş İlanının Dili', 'type' => 'select']
            );
        }

        //Profile Kariyer CV Folder Seeder
        if (!$folders->findBySlug('kariyer_cv')) {
            $disk = $disks->findBySlug('local');

            $folders->create([
                'en' => [
                    'name' => 'Kariyer CV',
                    'description' => 'A folder for Kariyer CV.',
                ],
                'slug' => 'kariyer_cv',
                'disk' => $disk
            ]);
        };

        //Profile CV Field Seeder
        $namespace = 'users';
        $locked = 0;
        $stream = $streamRepository->findBySlugAndNamespace('users', 'users');

        $customFields = [
            [
                'name' => 'visiosoft.module.kariyer::field.cv',
                'slug' => 'kariyer_cv',
                'type' => 'anomaly.field_type.file',
                'config' => [
                    'folders' => ["kariyer_cv"],
                    'mode' => 'upload',
                ]
            ]
        ];

        foreach ($customFields as $customField) {
            $field = $fieldRepository->findBySlugAndNamespace($customField['slug'], $namespace);

            if (!$field) {
                $data = [
                    'name' => $customField['name'],
                    'namespace' => $namespace,
                    'slug' => $customField['slug'],
                    'type' => $customField['type'],
                    'locked' => $locked
                ];

                if (isset($customField['config'])) {
                    $data['config'] = $customField['config'];
                }

                $field = $fieldRepository->create($data);

                $assignmentRepository->create([
                    'stream_id' => $stream->id,
                    'field_id' => $field->id
                ]);
            }
        }

        //Doping Seeder
        if (is_module_installed('visiosoft.module.dopings')) {

            $doping_type_repository = app(TypeRepositoryInterface::class);

            //Remove Unsupported Types
            $doping_type_repository->newQuery()->whereIn('slug', ['category_showcase', 'decreasing_prices', 'updated', 'fire_sale', 'home_page_showcase'])->delete();
        }
    }

}
