<?php namespace Visiosoft\KariyerModule\Kariyer;

use Illuminate\Support\Facades\Auth;
use Visiosoft\KariyerModule\Kariyer\Contract\KariyerRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class KariyerRepository extends EntryRepository implements KariyerRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var KariyerModel
     */
    protected $model;

    /**
     * Create a new KariyerRepository instance.
     *
     * @param KariyerModel $model
     */
    public function __construct(KariyerModel $model)
    {
        $this->model = $model;
    }

    public function newApply($id, $user_id = null)
    {
        return $this->newQuery()->create([
            'user_id' => (Auth::check() && !$user_id) ? Auth::id() : $user_id,
            'ad_id' => $id,
            'status' => 'pending'
        ]);
    }
}
