<?php namespace Visiosoft\KariyerModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\KariyerModule\Kariyer\Contract\KariyerRepositoryInterface;

class KariyerController extends ResourceController
{
    protected $ad;
    protected $kariyer;

    public function __construct(AdvRepositoryInterface $advRepository, KariyerRepositoryInterface $kariyer)
    {

        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }

        $this->ad = $advRepository;
        $this->kariyer = $kariyer;
        parent::__construct();
    }

    public function apply($id)
    {
        $ad = $this->ad->newQuery()
            ->where('slug', '!=', null)
            ->where('status', 'approved')
            ->where('finish_at', '>', date('Y-m-d H:i:s'))
            ->where('advs_advs.id', $id)->first();

        if (!$ad) {
            $this->messages->error(trans('visiosoft.module.kariyer::message.not_found_job'));
            return redirect('/');
        }

        $apply = $this->kariyer->newApply($id);

        $this->messages->info(trans('visiosoft.module.kariyer::message.application_was_made'));
        return back();
    }

    public function dashboard()
    {
        return $this->view->make('visiosoft.module.kariyer::dashboard');
    }

    public function updateStatus($id)
    {
        if($kariyer = $this->kariyer->find($id) and $this->request->has('status'))
        {
            $kariyer->setStatus($this->request->get('status'));
            $this->messages->success(trans('visiosoft.module.kariyer::message.status_updated'));
        }
        return $this->redirect->to(route('visiosoft.module.kariyer::dashboard')."#adaylar");
    }
}
