<?php namespace Visiosoft\KariyerModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\KariyerModule\Kariyer\Contract\KariyerRepositoryInterface;

class KariyerController extends ResourceController
{
    protected $ad;
    protected $kariyer;

    public function __construct(AdvRepositoryInterface $advRepository, KariyerRepositoryInterface $kariyer)
    {

        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }

        $this->ad = $advRepository;
        $this->kariyer = $kariyer;
        parent::__construct();
    }

    public function apply($id)
    {
        //Find Job
        $ad = $this->ad->newQuery()
            ->where('slug', '!=', null)
            ->where('status', 'approved')
            ->where('finish_at', '>', date('Y-m-d H:i:s'))
            ->where('advs_advs.id', $id)->first();

        //Check Job
        if (!$ad) {
            $this->messages->error(trans('visiosoft.module.kariyer::message.not_found_job'));
            return redirect('/');
        }

        //Check apply
        if ($this->kariyer->findByAdAndUser($ad->getId(), Auth::id())) {
            $this->messages->info(trans('visiosoft.module.kariyer::message.you_have_an_active_application'));
        } else {
            $this->kariyer->newApply($id);
            $this->messages->success(trans('visiosoft.module.kariyer::message.application_was_made'));
        }
        return $this->redirect->to(\route('adv_detail_seo', [$ad->slug, $ad->getId()]));
    }

    public function dashboard()
    {
        return $this->view->make('visiosoft.module.kariyer::dashboard');
    }

    public function updateStatus($id)
    {
        if ($kariyer = $this->kariyer->find($id) and $this->request->has('status')) {
            $kariyer->setStatus($this->request->get('status'));
            $this->messages->success(trans('visiosoft.module.kariyer::message.status_updated'));
        }
        return $this->redirect->to(route('visiosoft.module.kariyer::dashboard') . "#adaylar");
    }

    public function userDetail(UserRepositoryInterface $userRepository, $user_id)
    {
        if ($user = $userRepository->find($user_id)) {
            return $this->view->make('visiosoft.module.kariyer::user-detail/detail', compact('user'));
        }

        $this->messages->error(trans('visiosoft.module.kariyer::message.user_detail_error'));
        return $this->redirect->to('/kariyer/dashboard#adaylar');
    }

    public function myApplications()
    {
        $my_applications = $this->kariyer->getByUser(Auth::id());

        return $this->view->make('module::my-applications',compact('my_applications'));
    }
}
