<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\SuspendSite;

class JenkinsSuspend
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(SuspendSite $event)
    {


        $this->site->newRequest([
            'subDomain' => $event->getSite()->subdomain_name,
            'suspend' => $event->getStatus(),
        ]);


        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'suspend' => $event->getStatus(),
        ]);

    }
}
