<?php namespace Visiosoft\SiteMethodJenkinsModule\Listener;

use Visiosoft\CloudsiteModule\Site\Event\DeleteSite;

class JenkinsDelete
{
    public function handle(DeleteSite $event)
    {
        $username = $event->settings->value('visiosoft.module.site_method_jenkins::username');
        $token = $event->settings->value('visiosoft.module.site_method_jenkins::token');
        $url = $event->settings->value('visiosoft.module.site_method_jenkins::url');
        $token_parameter = $event->settings->value('visiosoft.module.site_method_jenkins::token_parameter');
        $endpoint = "http://".$username.":".$token."@".$url;
        $client = new \GuzzleHttp\Client();
        $delete = "true";
        $subDomain = $event->request;

        $client->request('POST', $endpoint, ['query' => [
            'token' => $token_parameter,
            'delete' => $delete,
            'subDomain' => $subDomain
        ]]);
    }
}
