<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\UpdateSite;

class JenkinsUpdate
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(UpdateSite $event)
    {
        $this->site->newRequest([
            'subDomain' => $event->getSite()->subdomain_name,
        ]);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'update' => true,
        ]);

    }
}
