<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\DeleteSite;

class JenkinsDelete
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(DeleteSite $event)
    {
        $this->site->newRequest([
            'subDomain' => $event->getSite()->subdomain_name,
            'delete' => "true",
        ]);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'delete' => "true",
        ]);

    }
}
