<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CreateDomain;

class JenkinsAddDomainSite
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(CreateDomain $event)
    {
        $this->site->newRequest([
            'subDomain' => $event->getSite()->subdomain_name,
            'domain' => $event->getDomain()->domain
        ]);

        $this->site->create([
            'subDomain' => $event->getSite()->subdomain_name,
            'domain' => $event->getDomain()->domain
        ]);
    }
}
