<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Domain\Event\DeleteDomain;

class JenkinsDeleteDomainSite
{
    private $site;
    private $cwp;
    private $message;

    public function __construct(SiteRepositoryInterface $site, TaskRepositoryInterface $cwp, MessageBag $message)
    {
        $this->site = $site;
        $this->message = $message;
        $this->cwp = $cwp;
    }

    public function handle(DeleteDomain $event)
    {
        //Delete Domain
        $domain = $this->cwp->newRequest('admindomains',null,$event->getSite()->node, [
            'action' => 'del',
            'user' => $event->getSite()->subdomain_name,
            'type' => 'domain',
            'name' => $event->getDomain()->domain,
        ]);

        $response = json_decode($domain->response, true);

        //Domain silinmesi başarılı
        if($response)
        {
            if ($response['status'] == "OK") {
                return ['status' => true];
            }
            return ['status' => false, 'message' => $response['msj']];
        }
        return ['status' => false, 'message' => trans('streams::message.no_results')];
    }
}
