<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\DeleteSite;

class JenkinsDelete
{
    private $site;
    private $cwp;

    public function __construct(SiteRepositoryInterface $site, TaskRepositoryInterface $cwp)
    {
        $this->site = $site;
        $this->cwp = $cwp;
    }

    public function handle(DeleteSite $event)
    {
        //Delete Account
        $response = $this->cwp->newRequest('account',null,$event->getSite()->node, [
            'action' => 'del',
            'user' => $event->getSite()->subdomain_name
        ]);

        $response = json_decode($response->response, true);

        if ($response['status'] == "OK") {
            return ['status' => true];
        }
        return ['status' => false, 'message' => $response['msj']];
    }
}
