<?php namespace Visiosoft\SiteMethodJenkinsModule\Listener;

use Visiosoft\ProfileModule\Profile\Event\SiteStatusControl;

class JenkinsControl
{
    public function handle(SiteStatusControl $event)
    {
        $username = $event->settings->value('visiosoft.module.site_method_jenkins::username');
        $token = $event->settings->value('visiosoft.module.site_method_jenkins::token');
        $url = $event->settings->value('visiosoft.module.site_method_jenkins::control_url');

        $endpoint = "http://".$username.":".$token."@".$url."&xpath=//build[queueId=".$event->request."]";
        $client = new \GuzzleHttp\Client();


        $response = $client->request('POST', $endpoint);
        $xml = simplexml_load_string($response->getBody()->getContents(), "SimpleXMLElement", LIBXML_NOCDATA);
        $json = json_encode($xml);
        $array = json_decode($json,TRUE);
        return $array;
    }
}
