<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\UpdateSite;

class JenkinsUpdate
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(UpdateSite $event)
    {
        $this->site->newRequest([
            'userCWP' => $event->getSite()->subdomain_name,
            'node' => $event->getSite()->getServer(),
        ]);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'update' => true,
        ]);

    }
}
