<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;

class JenkinsCheckActivated
{
    /**
     * @var SiteRepositoryInterface
     */
    private $site;

    /**
     * JenkinsCheckActivated constructor.
     * @param SiteRepositoryInterface $site
     */
    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    /**
     * @param CheckActivatedSite $event
     * @return mixed
     */
    public function handle(CheckActivatedSite $event)
    {
        $site = $this->site->newQuery()
            ->where('subdomain',$event->getSite()
            ->subdomain_name)->first();

        $response = $this->site->checkStatusRequest($site->queueId);

        return $response;
    }
}
