<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CreateSite;

class JenkinsCreate
{
    private $site;
    private $cwp;
    private $message;

    public function __construct(SiteRepositoryInterface $site, TaskRepositoryInterface $cwp, MessageBag $message)
    {
        $this->site = $site;
        $this->cwp = $cwp;
        $this->message = $message;
    }

    public function handle(CreateSite $event)
    {
        try {
            $cwp = $this->cwp->newSiteAndDatabase($event->getSubdomain(),
                $event->getAssign()->username, $event->getAssign()->email, $event->getType());

            if ($cwp['account_status'] and $cwp['database_status']) {
                $response = $this->site->newRequest([
                    'userCWP' => $cwp['username'],
                    'projectUrl' => $event->getType(),
                    'newInstallation' => "true",
                    'adminUserName' => $event->getAssign()->username,
                    'adminPass' => $event->getPassword(),
                    'adminEmail' => $event->getAssign()->email,
                    'dbUser' => $cwp['username'],
                    'dbPass' => $cwp['pass'],
                    'dbName' => $cwp['database']
                ]);

                $response_link = $response->getHeader('Location')[0];
                $response_params = array_values(array_filter(explode('/', $response_link)));
                $response_id = end($response_params);

                $this->site->create([
                    'subdomain' => $event->getSubdomain(),
                    'email' => $event->getAssign()->email,
                    'username' => $event->getAssign()->username,
                    'password' => $event->getPassword(),
                    'create' => true,
                    'queueId' => $response_id,
                ]);
                $cwp['status'] = true;
                return $cwp;
            } else {
                $cwp['status'] = false;
                return $cwp;
            }
        } catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage()];
        }
    }
}
