<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Domain\Event\CreateDomain;

class JenkinsAddDomainSite
{
    private $site;
    private $cwp;
    private $message;

    public function __construct(SiteRepositoryInterface $site, TaskRepositoryInterface $cwp, MessageBag $message)
    {
        $this->site = $site;
        $this->message = $message;
        $this->cwp = $cwp;
    }

    public function handle(CreateDomain $event)
    {
        //TODO Review and Code Flush

        //Add Domain Account
        $domain = $this->cwp->newRequest('admindomains', [
            'action' => 'add',
            'user' => $event->getSite()->subdomain_name,
            'type' => 'domain',
            'name' => $event->getDomain(),
            'path' => '/public_html',
            'autossl' => "0",
        ]);

        $response = json_decode($domain->response, true);
        if ($response['status'] == "OK") {

            //Add SSL For Domain
            $ssl = $this->cwp->newRequest('autossl', [
                'action' => 'add',
                'user' => $event->getSite()->subdomain_name,
                'name' => $event->getDomain(),
            ]);

            $response = json_decode($ssl->response, true);

            if ($response['status'] == "OK") {
                return true;
            } else {
                $this->message->error([$response['msj']]);
                return null;
            }

        } else {
            $this->message->error([$response['msj']]);
            return null;
        }
    }
}
