<?php namespace Visiosoft\JenkinsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsAddAddon;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsAddDomainSite;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsCheckActivated;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsCheckAddonInstall;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsCreate;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsDelete;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsDeleteAddon;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsInstallAddon;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsSuspend;
use Visiosoft\JenkinsModule\Site\Listener\JenkinsUpdate;
use Visiosoft\JenkinsModule\Site\SiteRepository;
use Anomaly\Streams\Platform\Model\Jenkins\JenkinsSiteEntryModel;
use Visiosoft\JenkinsModule\Site\SiteModel;
use Illuminate\Routing\Router;
use Visiosoft\SiteModule\Domain\Event\CreateDomain;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;
use Visiosoft\SiteModule\Site\Event\CheckActivatedSite;
use Visiosoft\SiteModule\Site\Event\CheckCompletedAddonInstall;
use Visiosoft\SiteModule\Site\Event\CreateSite;
use Visiosoft\SiteModule\Site\Event\DeleteAddonSite;
use Visiosoft\SiteModule\Site\Event\DeleteSite;
use Visiosoft\SiteModule\Site\Event\installAddon;
use Visiosoft\SiteModule\Site\Event\SuspendSite;
use Visiosoft\SiteModule\Site\Event\UpdateSite;

class JenkinsModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/jenkins' => 'Visiosoft\JenkinsModule\Http\Controller\Admin\SiteController@index',
        'admin/jenkins/create' => 'Visiosoft\JenkinsModule\Http\Controller\Admin\SiteController@create',
        'admin/jenkins/edit/{id}' => 'Visiosoft\JenkinsModule\Http\Controller\Admin\SiteController@edit',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\JenkinsModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\JenkinsModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        CreateSite::class => [
            JenkinsCreate::class
        ],
        CheckActivatedSite::class => [
            JenkinsCheckActivated::class
        ],
        UpdateSite::class => [
            JenkinsUpdate::class
        ],
        SuspendSite::class => [
            JenkinsSuspend::class
        ],
        DeleteSite::class => [
            JenkinsDelete::class
        ],
        AddAddonSite::class => [
            JenkinsAddAddon::class
        ],
        DeleteAddonSite::class => [
            JenkinsDeleteAddon::class
        ],
        installAddon::class => [
            JenkinsInstallAddon::class
        ],
        CreateDomain::class => [
            JenkinsAddDomainSite::class
        ],
        CheckCompletedAddonInstall::class => [
            JenkinsCheckAddonInstall::class,
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\JenkinsModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        JenkinsSiteEntryModel::class => SiteModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        SiteRepositoryInterface::class => SiteRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
