<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\installAddon;

class JenkinsInstallAddon
{
    private $site;

    public function __construct(SiteRepositoryInterface $site)
    {
        $this->site = $site;
    }

    public function handle(installAddon $event)
    {
        $addon = $event->getAddon();
        $this->site->newRequest([
            'subDomain' => $event->getSite()->subdomain_name,
            'addon_name' => array_first($addon),
            'addon_type' => end($addon),
        ]);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'addon' => true,
            'addonName' => array_first($addon),
            'addonType' => end($addon),
        ]);

    }
}
