<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CreateSite;

class JenkinsCreate
{
    private $site;
    private $cwp;

    public function __construct(SiteRepositoryInterface $site, TaskRepositoryInterface $cwp)
    {
        $this->site = $site;
        $this->cwp = $cwp;
    }

    public function handle(CreateSite $event)
    {
        $cwp = $this->cwp->newSiteAndDatabase($event->getSite()->subdomain_name . ".openclassify.com",
            $event->getAssign()->username, $event->getAssign()->email);

        $response = $this->site->newRequest([
            'subDomain' => $event->getSite()->subdomain_name,
            'newInstallation' => "true",
            'adminUserName' => $event->getAssign()->username,
            'adminPass' => $event->getSite()->password,
            'adminEmail' => $event->getAssign()->email,
            'dbUser' => $cwp['username'],
            'dbPass' => $cwp['pass'],
            'dbName' => $cwp['database']
        ]);

        $response_link = $response->getHeader('Location')[0];
        $response_params = array_values(array_filter(explode('/', $response_link)));
        $response_id = end($response_params);

        $this->site->create([
            'subdomain' => $event->getSite()->subdomain_name,
            'email' => $event->getAssign()->email,
            'username' => $event->getAssign()->username,
            'password' => $event->getSite()->password,
            'create' => true,
            'queueId' => $response_id,
        ]);

    }
}
