<?php namespace Visiosoft\JenkinsModule\Site\Listener;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Visiosoft\JenkinsModule\Site\Contract\SiteRepositoryInterface;
use Visiosoft\SiteModule\Site\Event\CreateDomain;

class JenkinsAddDomainSite
{
    private $site;
    private $cwp;

    public function __construct(SiteRepositoryInterface $site,TaskRepositoryInterface $cwp)
    {
        $this->site = $site;
        $this->cwp = $cwp;
    }

    public function handle(CreateDomain $event)
    {

        //Add Domain Account
        $this->cwp->newRequest('admindomains',[
            'action' => 'add',
            'user' => $event->getSite()->assign->username,
            'type' => 'domain',
            'name' => $event->getDomain()->domain,
            'path' => '/public_html',
            'autossl' => "1",
        ]);

//        $this->site->newRequest([
//            'subDomain' => $event->getSite()->subdomain_name,
//            'domain' => $event->getDomain()->domain
//        ]);

        $this->site->create([
            'subDomain' => $event->getSite()->subdomain_name,
            'domain' => $event->getDomain()->domain
        ]);
    }
}
