<?php namespace Visiosoft\SiteMethodJenkinsModule\Listener;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Visiosoft\CloudsiteModule\Site\Event\UpdateSite;

class JenkinsUpdate
{
    public function handle(UpdateSite $event)
    {
        $username = $event->settings->value('visiosoft.module.site_method_jenkins::username');
        $token = $event->settings->value('visiosoft.module.site_method_jenkins::token');
        $url = $event->settings->value('visiosoft.module.site_method_jenkins::url');
        $token_parameter = $event->settings->value('visiosoft.module.site_method_jenkins::token_parameter');
        $endpoint = "http://".$username.":".$token."@".$url;

        $client = new \GuzzleHttp\Client();
        $newInstallation = "false";
        $subDomain = $event->request;

        $client->request('POST', $endpoint, ['query' => [
            'token' => $token_parameter,
            'newInstallation' => $newInstallation,
            'subDomain' => $subDomain
        ]]);
    }
}
